//==============================================================================
// SU_SpineTouchCommon.js
//
// Version : 0.9.0 2023/05/31
//==============================================================================
/*:
 * @plugindesc Spine の境界ボックスをボタンとして扱うプラグイン
 * @author SU
 *
 * @help
 * ピクチャで表示されたSpineスケルトンに設定された境界ボックスをボタンとして扱うプラグインです。
 * プラグインコマンドでコモンイベントを紐づけ、クリックで呼び出すことができます。
 *
 * 前提プラグインとして PictureSpine.js が必要ですので、このプラグインよりも上に配置してください。
 *
 * ============================================================================
 * プラグインコマンド
 * ============================================================================
 * - S_TCOMMON_SET pictureID boxName commonEventID
 *  指定するピクチャ（スケルトン）の境界ボックスにコモンイベントを紐づけします。
 *  同じ境界ボックスに対して複数回実行すると、後に実行したコマンドによって上書きされます。
 *   pictureID : ピクチャ番号
 *   boxName : 境界ボックスの名前
 *   commonEventID : コモンイベントの番号
 *
 * 例）S_TCOMMON_SET 1 右腕 10
 *
 * - S_TCOMMON_CLEAR pictureID boxName
 *  指定したピクチャ（スケルトン）の境界ボックスに対する紐づけを解除します。
 *   pictureID : ピクチャ番号
 *   boxName : 境界ボックスの名前
 *
 * 例）S_TCOMMON_CLEAR 1 右腕
 *
 */
/*~struct~Button:
 * @param BoundingBoxName
 * @type string
 *
 * @param PointerDown
 * @type common_event
 *
 * @param PointerUp
 * @type common_event
 *
 * @param LongPress
 * @type common_event
 *
 * @param Enter
 * @type common_event
 *
 * @param Out
 * @type common_event
 *
 * @param Priority
 * @type number
 */
(() => {
    "use strict";
    var _a, _b;
    //=============================================================================
    // パラメータ読み出し
    //=============================================================================
    const pluginName = (_b = (_a = document.currentScript.src
        .split("/")
        .pop()) === null || _a === void 0 ? void 0 : _a.replace(/\.js$/, "")) !== null && _b !== void 0 ? _b : "";
    if (!pluginName) {
        return;
    }
    const params = PluginManager.parameters(pluginName);
    const parseNumber = (value) => Number(value);
    const parsedParams = JSON.parse(JSON.stringify(params, (key, value) => {
        try {
            return JSON.parse(value);
        }
        catch (e) { }
        return value;
    }));
    // const buttons: ButtonParam[] = parsedParams["Buttons"];
    //=============================================================================
    // クラス定義
    //=============================================================================
    //
    ((_init_) => {
        Game_Spine.prototype.init = function () {
            _init_.call(this);
            this._touchEvents = {};
            this._isPressing = false;
            this._holdingBox = "";
            // this._boundingBoxes =
            // const style = (document.body.style.cursor = "pointer");
        };
    })(Game_Spine.prototype.init);
    Game_Spine.prototype.setTouchEvent = function (boundingBoxName, eventId, type = "onClick") {
        if (!this._touchEvents[boundingBoxName]) {
            this._touchEvents[boundingBoxName] = {};
        }
        const targetBoundingBox = this._touchEvents[boundingBoxName];
        targetBoundingBox[type] = eventId;
    };
    Game_Spine.prototype.removeTouchEvent = function (boundingBoxName, type) {
        if (this._touchEvents[boundingBoxName]) {
            if (type)
                this._touchEvents[boundingBoxName][type] = 0;
            else
                this._touchEvents[boundingBoxName] = {};
        }
    };
    Game_Spine.prototype.touch = function () {
        var _a, _b, _c;
        if (TouchInput.isTriggered()) {
            const touchPos = { x: TouchInput.x, y: TouchInput.y };
            const hits = this.hitTest(touchPos.x, touchPos.y);
            if (!hits)
                return;
            if (hits.length === 0)
                return;
            while (hits.length) {
                const interacted = hits.pop();
                const attachmentName = (_a = interacted === null || interacted === void 0 ? void 0 : interacted.attachmentName) !== null && _a !== void 0 ? _a : "";
                const eventId = (_c = (_b = this._touchEvents[attachmentName]) === null || _b === void 0 ? void 0 : _b.onClick) !== null && _c !== void 0 ? _c : null;
                if (!eventId)
                    continue;
                $gameTemp._touchCommonId = eventId;
                break;
            }
        }
    };
    // Sprite_Spine.prototype.updateTouch = function () {
    //     const spine = this.spine();
    //     if (!spine) return;
    //     if (TouchInput.isTriggered()) {
    //         const touchPos: Vector2 = { x: TouchInput.x, y: TouchInput.y };
    //         const hits = this.hitTest(touchPos.x, touchPos.y);
    //         if (hits.length === 0) return;
    //         const interacted = hits.pop();
    //         const attachmentName: string = interacted?.attachmentName ?? "";
    //         console.log(interacted?.attachmentName);
    //         const eventId =
    //             this.spine()._touchEvents[attachmentName]?.onClick ?? null;
    //         if (!eventId) return;
    //         // $gameTemp.reserveCommonEvent(eventId);
    //         $gameTemp._touchCommonId = eventId;
    //         // const index = buttons.findIndex((p, i) => p.BoundingBoxName === attachmentName);
    //         // $gameTemp.reserveCommonEvent(buttons[index].CommonEvent);
    //         //
    //     }
    // };
    ((_setupStartingEvent_) => {
        Game_Map.prototype.setupStartingEvent = function () {
            return (_setupStartingEvent_.call(this) || this.setupTouchCommonEvent());
        };
    })(Game_Map.prototype.setupStartingEvent);
    Game_Map.prototype.setupTouchCommonEvent = function () {
        const commonId = $gameTemp._touchCommonId;
        const event = $dataCommonEvents[commonId];
        let result = false;
        if (!this.isEventRunning() && event) {
            this._interpreter.setupFromSpine(event.list, commonId);
            result = true;
        }
        $gameTemp._touchCommonId = 0;
        return result;
    };
    Game_Interpreter.prototype.setupFromSpine = function (eventList, commonId) {
        this.setup(eventList, 0);
        // if(this.setEventInfo){
        //         this.setEventInfo({eventType: 'common_event',
        //         commonEventId: commonId});
        // }
        this._setupFromSpine = true;
    };
    Game_Interpreter.prototype.isSetupFromSpine = function () {
        return this._setupFromSpine;
    };
    var iterate = function (that, handler) {
        Object.keys(that).forEach(function (key, index) {
            handler.call(that, key, that[key], index);
        });
    };
    Spriteset_Base.prototype.iteratePictures = function (callBackFund) {
        var containerChildren = this._pictureContainer.children;
        if (!Array.isArray(containerChildren)) {
            // iterate(this._pictureContainer,  (property: keyof Sprite) =>{
            //     if (this._pictureContainer[property]?.hasOwnProperty('children')) {
            //         containerChildren = this._pictureContainer[property]?.children ?? new Sprite();
            //         this._iteratePicturesSub(containerChildren, callBackFund);
            //     }
            // }.bind(this));
        }
        else {
            this._iteratePicturesSub(containerChildren, callBackFund);
        }
    };
    Spriteset_Base.prototype._iteratePicturesSub = function (containerChildren, callBackFund) {
        for (var i = containerChildren.length - 1; i >= 0; i--) {
            if (!callBackFund(containerChildren[i])) {
                break;
            }
        }
    };
    Scene_Base.prototype.updateSpineTouchDetection = function () { };
    Scene_Map.prototype.updateSpineTouchDetection = function () {
        Scene_Base.prototype.updateSpineTouchDetection.call(this);
        if ($gameMap.isEventRunning())
            return;
        const spriteset = this._spriteset;
        spriteset.iteratePictures((picture) => {
            if (!$gameScreen.picture(picture._pictureId))
                return true;
            $gameScreen.spine(picture._pictureId).touch();
            return $gameTemp._touchCommonId === 0;
        });
    };
    Scene_Battle.prototype.updateSpineTouchDetection = function () {
        Scene_Base.prototype.updateSpineTouchDetection.call(this);
        // if ($gameMap.isEventRunning()) return;
        const spriteset = this._spriteset;
        spriteset.iteratePictures((picture) => {
            if (!$gameScreen.picture(picture._pictureId))
                return true;
            $gameScreen.spine(picture._pictureId).touch();
            return $gameTemp._touchCommonId === 0;
        });
    };
    ((_update_) => {
        Scene_Map.prototype.update = function () {
            this.updateSpineTouchDetection();
            _update_.call(this);
        };
    })(Scene_Map.prototype.update);
    ((_update_) => {
        Scene_Battle.prototype.update = function () {
            this.updateSpineTouchDetection();
            $gameTroop.updateAllSpineCommonEvent();
            _update_.call(this);
        };
    })(Scene_Battle.prototype.update);
    // この関数中ででマップクリック判定をしているので、これが呼ばれる前に Spine のタッチ判定を入れなければいけない
    ((_processMapTouch_) => {
        Scene_Map.prototype.processMapTouch = function () {
            _processMapTouch_.call(this);
            // イベントが発行されている場合はクリックによる移動をキャンセルする
            if ($gameTemp.isDestinationValid() && $gameTemp._touchCommonId) {
                $gameTemp.clearDestination();
            }
        };
    })(Scene_Map.prototype.processMapTouch);
    Game_Troop.prototype.setupTouchCommonEvent =
        Game_Map.prototype.setupTouchCommonEvent;
    // Game_Troop.prototype.setupSpineParallelCommonEvent = Game_Map.prototype.setupSineParallelCommonEvent;
    // Game_Troop.prototype.updateSpineCommonEvents = Game_Map.prototype.updateSpineCommonEvents;
    Game_Troop.prototype.updateAllSpineCommonEvent = function () {
        this.setupTouchCommonEvent();
    };
    Game_Troop.prototype.isExistTouchCommon = function () {
        return this._interpreter.isSetupFromSpine();
    };
    ((_updateBattleProcess_) => {
        Scene_Battle.prototype.updateBattleProcess = function () {
            let res = BattleManager.prototype.updateTouchCommon();
            if (res)
                return;
            _updateBattleProcess_.call(this);
        };
    })(Scene_Battle.prototype.updateBattleProcess);
    BattleManager.prototype.updateTouchCommon = function () {
        if ($gameTroop.isExistTouchCommon()) {
            BattleManager.updateEventMain();
            return true;
        }
        return false;
    };
    //=============================================================================
    // プラグインコマンド
    //=============================================================================
    ((_pluginCommand_) => {
        Game_Interpreter.prototype.pluginCommand = function (command, args) {
            _pluginCommand_.apply(this, [command, args]);
            const com = command.toUpperCase();
            switch (com) {
                case "S_TCOMMON_SET":
                    if (Number.isNaN(args[0])) {
                    }
                    else {
                        const id = Number(args[0]);
                        const spine = $gameScreen
                            .spine(id)
                            .setTouchEvent(args[1], Number(args[2]), args[3]);
                    }
                case "S_TCOMMON_CLEAR":
                    if (Number.isNaN(args[0])) {
                    }
                    else {
                        const id = Number(args[0]);
                        const spine = $gameScreen
                            .spine(id)
                            .removeTouchEvent(args[1], args[2]);
                    }
            }
        };
    })(Game_Interpreter.prototype.pluginCommand);
})();
